/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.RecipeWrapperSerializer;

public class SmithingBackpackUpgradeRecipe
extends SmithingRecipe
implements IWrapperRecipe<SmithingRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    private final SmithingRecipe compose;

    public SmithingBackpackUpgradeRecipe(SmithingRecipe compose) {
        super(compose.func_199560_c(), Objects.requireNonNull((Ingredient)ObfuscationReflectionHelper.getPrivateValue(SmithingRecipe.class, (Object)compose, (String)"field_234837_a_")), Objects.requireNonNull((Ingredient)ObfuscationReflectionHelper.getPrivateValue(SmithingRecipe.class, (Object)compose, (String)"field_234838_b_")), compose.func_77571_b());
        this.compose = compose;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack upgradedBackpack = this.getCraftingResult().func_77946_l();
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.func_77978_p())).ifPresent(tag -> upgradedBackpack.func_77982_d(tag.func_74737_b()));
            upgradedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                BackpackItem backpackItem = (BackpackItem)upgradedBackpack.func_77973_b();
                wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
            });
        }
        return upgradedBackpack;
    }

    private ItemStack getCraftingResult() {
        return Objects.requireNonNull((ItemStack)ObfuscationReflectionHelper.getPrivateValue(SmithingRecipe.class, (Object)this, (String)"field_234839_c_"));
    }

    private Optional<ItemStack> getBackpack(IInventory inv) {
        ItemStack slotStack = inv.func_70301_a(0);
        if (slotStack.func_77973_b() instanceof BackpackItem) {
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    @Override
    public SmithingRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<SmithingRecipe, SmithingBackpackUpgradeRecipe> {
        public Serializer() {
            super(SmithingBackpackUpgradeRecipe::new, IRecipeSerializer.field_234826_u_);
        }
    }
}

